﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        public class ContextParam : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
        {
            public class Menu
            {
                private bool _isNextExercise = false;
                private bool _isPreviousExercise = false;
                private bool _isCheck = false;
                private bool _isResolve = false;
                private bool _isReload = false;
                private bool _isMenu = false;
                private int _ModeID = (int)PI.GM.N610.ELearning.BL.Dictionary.ModeType.None;

                public int ModeID
                {
                    get { return _ModeID; }
                }

                public bool IsNextExercise
                {
                    get { return _isNextExercise; }
                }

                public bool IsPreviousExercise
                {
                    get { return _isPreviousExercise; }
                }

                public bool IsCheck
                {
                    get { return _isCheck; }
                }

                public bool IsResolve
                {
                    get { return _isResolve; }
                }

                public bool IsReload
                {
                    get { return _isReload; }
                }

                public bool IsMenu
                {
                    get { return _isMenu; }
                }

                public Menu(ContextParam ContextParam)
                {
                    _ModeID = (int)ContextParam.Mode;

                    if (ContextParam.AuxyliaryPages == Dictionary.AuxyliaryPagesType.None)
                    {

                        if (ContextParam.CourseType == Dictionary.Category.CourseType.CompetenceTheory)
                        {
                            FreeNavigation(ContextParam);
                        }
                        else
                        {
                            if (ContextParam.Group == Dictionary.GroupType.Student)
                            {
                                if (ContextParam.Mode == GM.N610.ELearning.BL.Dictionary.ModeType.History)
                                {
                                    HistoryNavigation(ContextParam);
                                }
                                else
                                {
                                    ForwardOnlyNavigation(ContextParam);
                                }
                            }
                            else
                            {
                                FreeNavigation(ContextParam);
                            }
                        }
                    }
                    else
                    {
                        AuxiliaryPage(ContextParam);
                    }
                }

                private void ForwardOnlyNavigation(ContextParam ContextParam)
                {
                    _isMenu = false;
                    _isPreviousExercise = false;

                    switch (ContextParam.ExerciseState)
                    {
                        case PI.GM.N610.ELearning.BL.ELearning.ExerciseState.Load:
                            {
                                _isReload = false;
                                _isCheck = ContextParam.IsResolveable;
                                _isResolve = false;
                                if (ContextParam.IsResolveable)
                                {
                                    _isNextExercise = false;
                                }
                                else
                                {
                                    _isNextExercise = true;
                                }
                                break;
                            }
                        case PI.GM.N610.ELearning.BL.ELearning.ExerciseState.Check:
                            {
                                _isReload = false;
                                _isCheck = false;
                                _isResolve = ContextParam.IsResolveable;

                                if (ContextParam.IsResolveable)
                                {
                                    _isNextExercise = false;
                                }
                                else
                                {
                                    _isNextExercise = true;
                                }
                                break;
                            }
                        case PI.GM.N610.ELearning.BL.ELearning.ExerciseState.Resolve:
                            {
                                _isReload = false;
                                _isCheck = false;
                                _isResolve = false;
                                _isNextExercise = ContextParam.IsNextExercise;
                                break;
                            }
                    }
                }

                private void FreeNavigation(ContextParam ContextParam)
                {
                    _isMenu = ContextParam.IsMenu;
                    _isNextExercise = ContextParam.IsNextExercise;
                    _isPreviousExercise = ContextParam.IsPreviousExercise;

                    switch (ContextParam.ExerciseState)
                    {
                        case PI.GM.N610.ELearning.BL.ELearning.ExerciseState.Load:
                            {
                                _isReload = false;
                                _isCheck = ContextParam.IsResolveable;
                                _isResolve = ContextParam.IsResolveable;
                                break;
                            }
                        case PI.GM.N610.ELearning.BL.ELearning.ExerciseState.Check:
                            {
                                _isReload = ContextParam.IsResolveable;
                                _isCheck = false;
                                _isResolve = ContextParam.IsResolveable;

                                break;
                            }
                        case PI.GM.N610.ELearning.BL.ELearning.ExerciseState.Resolve:
                            {
                                _isReload = ContextParam.IsResolveable;
                                _isCheck = false;
                                _isResolve = false;
                                break;
                            }
                    }
                }

                private void HistoryNavigation(ContextParam ContextParam)
                {
                    _isMenu = false;
                    _isNextExercise = true;
                    _isPreviousExercise = true;
                    _isReload = false;
                    _isCheck = false;
                    _isResolve = false;
                }

                private void AuxiliaryPage(ContextParam ContextParam)
                {
                    switch(ContextParam.AuxyliaryPages)
                    {
                        case Dictionary.AuxyliaryPagesType.Fraud:
                            {
                                _isNextExercise = true;
                                _isPreviousExercise = false;
                                _isMenu = false;
                                _isReload = false;
                                _isCheck = false;
                                _isResolve = false;
                                break;
                            }

                        case Dictionary.AuxyliaryPagesType.StartSummary:
                            {
                                _isNextExercise = ContextParam.PageCount > 0;          
                                _isPreviousExercise = false;
                                _isMenu = false;
                                _isReload = false;
                                _isCheck = false;
                                _isResolve = false;
                                break;
                            }
                        case Dictionary.AuxyliaryPagesType.Summary:
                            {
                                if (ContextParam.Mode == GM.N610.ELearning.BL.Dictionary.ModeType.History)
                                {
                                    _isNextExercise = ContextParam.PageCount > 0;   
                                    _isPreviousExercise = false;
                                    _isMenu = false;
                                    _isReload = false;
                                    _isCheck = false;
                                    _isResolve = false;
                                }
                                else
                                {
                                    goto default;
                                }

                                break;
                            }

                        default:
                            {
                                _isNextExercise = false;
                                _isPreviousExercise = false;
                                _isMenu = false;
                                _isReload = false;
                                _isCheck = false;
                                _isResolve = false;
                                break;
                            }
                    }
                }
            }

            private Dictionary.AuxyliaryPagesType _auxyliaryPage = Dictionary.AuxyliaryPagesType.None;

            private  PI.GM.N610.ELearning.BL.Dictionary.ModeType _mode = PI.GM.N610.ELearning.BL.Dictionary.ModeType.None;
            private long? _contextObjectID = null;
            private long? _statisticContextID = null;
            private PI.GM.N610.ELearning.BL.BO.Categorization _cuourseType = null;

            private decimal? _RandomizePercent = null;

            private PI.ZB.N1200.ELearning.BL.BO.Instructor _instructor = null;
            private PI.ZB.N1200.ELearning.BL.BO.Student _student = null;
            private PI.ZB.N1200.ELearning.BL.BO.Class _class = null;
            private PI.ZB.N1200.ELearning.BL.BO.CompetencePart _competencePart = null;
            private PI.ZB.N1200.ELearning.BL.BO.Competence _competence = null;

            private PI.ZB.N1200.ELearning.BL.BO.AdvancedLevel _AdvancedLevel = null;
            private PI.ZB.N1200.ELearning.BL.BO.EvaluationSheet _currentEvaluationSheet = null;

            private int? _exerciseDifficultyID = null;

            PI.GM.N610.ELearning.BL.BO.Exercise _exerciseIn = null;
            PI.GM.N610.ELearning.BL.BO.Unit _unitIn = null;
            PI.GM.N610.ELearning.BL.BO.Course _course = null;

            PI.GM.N610.ELearning.BL.BO.Exercise _exerciseOut = null;
            PI.GM.N610.ELearning.BL.BO.Unit _unitOut = null;

            private bool? _isCourseFinished = null;
            private bool? _isCompetencePartAvailable = null;
            private bool? _isExerciseAlreadyChecked = null;
            private bool? _isExerciseAlreadyResolved = null;
            
            private bool  _isValidContextCalculated = false;
            private bool? _isValidContext = null;
            private ContextParam _validContext = null;

            List<PI.ZB.N1200.ELearning.BL.BO.View.Unit> _listUnit = null;

            PI.GM.N610.ELearning.BL.ELearning.ExerciseState _exerciseState = GM.N610.ELearning.BL.ELearning.ExerciseState.Load;


            private bool _isPageCalculated = false;
            private int _pageNr = 0;
            private int _pageCount = 0;

            private bool _isNextExercise = false;
            private bool _isPreviousExercise = false;

            private Menu _menu = null;

            public Menu BreadcrumbsMenu
            {
                get
                {
                    if (_menu == null)
                    {
                        _menu = new Menu(this);
                    }

                    return _menu;
                }
            }

            public ContextParam(ZSBELearning BL, long? ContextObjectID, long? CourseID, long? UnitID, long? ExerciseID, long? StatisticContextID, int? ModeID)
                : base(BL)
            {
                    if (ModeID.HasValue)
                    {
                        _mode = (PI.GM.N610.ELearning.BL.Dictionary.ModeType)ModeID;
                    }
                    else
                    {
                        _mode = PI.GM.N610.ELearning.BL.Dictionary.ModeType.None;
                    }

                _course = BL.BLELearning.Course.Restore(CourseID);

                if (UnitID.HasValue)
                {
                    _unitIn = BL.BLELearning.Unit.Restore(UnitID);
                    _unitOut = _unitIn;
                }

                if (ExerciseID.HasValue)
                {
                    if (ExerciseID > 0)
                    {
                        _exerciseIn = BL.BLELearning.Exercise.Restore(ExerciseID);
                        _exerciseOut = _exerciseIn;
                    }
                    else
                    {
                        _auxyliaryPage = (Dictionary.AuxyliaryPagesType)ExerciseID;
                    }
                }

                _contextObjectID = ContextObjectID;
                _statisticContextID = StatisticContextID;
            }

            public ContextParam(ZSBELearning BL, long? ContextObjectID, long? CourseID, long? StatisticContextID, PI.GM.N610.ELearning.BL.Dictionary.ModeType Mode)
                : base(BL)
            {
                _mode = Mode;
                _course = BL.BLELearning.Course.Restore(CourseID);
                _contextObjectID = ContextObjectID;
                _statisticContextID = StatisticContextID;
            }

            public PI.GM.N610.ELearning.BL.Dictionary.ModeType Mode
            {
                get
                {
                    return _mode;
                }
                set
                {
                    _mode = value;
                    _menu = null;
                }
            }

            public long ContextObjectID
            {
                get { return _contextObjectID.Value; }
            }

            public long? StatisticContextID
            {
                get { return _statisticContextID; }
            }


            public PI.ZB.N1200.ELearning.BL.BO.Class Class
            {
                get
                {
                    if (Group == Dictionary.GroupType.Student)
                    {
                        _class = BLP.Class.Restore(Student);
                    }

                    return _class;
                }
            }

            public PI.ZB.N1200.ELearning.BL.BO.CompetencePart CompetencePart
            {
                get
                {
                    if (_competencePart == null)
                    {
                        if (CourseType == Dictionary.Category.CourseType.CompetenceCourse || CourseType == Dictionary.Category.CourseType.Case || CourseType == Dictionary.Category.CourseType.CompetenceTheory)
                        {
                            _competencePart = BLP.CompetencePart.Restore(ContextObjectID);
                        }
                    }

                    return _competencePart;
                }
            }

            public PI.ZB.N1200.ELearning.BL.BO.Competence Competence
            {
                get
                {
                    if (_competence == null)
                    {
                        if (CourseType == Dictionary.Category.CourseType.CompetenceCourse || CourseType == Dictionary.Category.CourseType.Case)
                        {
                            _competence = BLP.Competence.Restore(CompetencePart);
                        }
                    }

                    return _competence;
                }
            }

            public PI.ZB.N1200.ELearning.BL.BO.Student Student
            {
                get
                {
                    if ((_student == null) && (Group == Dictionary.GroupType.Student))
                    {
                        _student = BLP.Student.RestoreByUser(BLP.Environment.User);
                    }

                    return _student;
                }
            }

            public PI.ZB.N1200.ELearning.BL.BO.Instructor Instructor
            {
                get
                {
                    if ((_instructor == null) && (Group == Dictionary.GroupType.Instructor))
                    {
                        _instructor = BLP.Instructor.RestoreByUser(BLP.Environment.User);
                    }

                    return _instructor;
                }
            }

            public BL.Dictionary.GroupType Group
            {
                get
                {
                    return (BL.Dictionary.GroupType)BLP.Environment.User.GroupEnumID;
                }
            }

            public BL.Dictionary.Category.CourseType CourseType
            {
                get
                {
                    if (_cuourseType == null)
                    {
                        _cuourseType = BLP.BLELearning.Categorizatoin.Restore(_course.TypeID);
                    }

                    return (BL.Dictionary.Category.CourseType)_cuourseType.EnumID;
                }
            }

            public bool IsValid
            {
                get
                {
                    if ((_contextObjectID.HasValue) && (_course != null) && (_unitIn != null) && (_exerciseIn != null))
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
            }

            public PI.GM.N610.ELearning.BL.BO.Course Course
            {
                get
                {
                    return _course;
                }
            }

            public PI.GM.N610.ELearning.BL.BO.Unit UnitIn
            {
                get
                {
                    return _unitIn;
                }
            }

            public PI.GM.N610.ELearning.BL.BO.Exercise ExerciseIn
            {
                get
                {
                    return _exerciseIn;
                }
            }


            public PI.GM.N610.ELearning.BL.BO.Unit UnitOut
            {
                get
                {
                    if (_unitOut == null)
                    {
                        _unitOut = BLP.BLELearning.Unit.New();
                        _unitOut.ID = 0;
                    }

                    return _unitOut;
                }
                set
                {
                    _unitOut = value;
                }
            }

            public PI.GM.N610.ELearning.BL.BO.Exercise ExerciseOut
            {
                get
                {
                    if (_exerciseOut == null)
                    {
                        _exerciseOut = BLP.BLELearning.Exercise.New();
                        _exerciseOut.ID = (int)_auxyliaryPage;
                    }
                    return _exerciseOut;
                }
                set
                {
                    _exerciseOut = value;
                }
            }


            public PI.GM.N610.ELearning.BL.ELearning.ExerciseState ExerciseState
            {
                get
                {
                    return _exerciseState;
                }
                set
                {
                    _exerciseState = value;
                }
            }

            public List<PI.ZB.N1200.ELearning.BL.BO.View.Unit> Units
            {
                get
                {
                    if (_listUnit == null)
                    {
                        _listUnit = BLP.Unit.Restore(ContextObjectID, Course, ExerciseDifficultyID);
                    }

                    return _listUnit;
                }
            }

            private PI.ZB.N1200.ELearning.BL.BO.View.Unit Unit(long? ID)
            {
                PI.ZB.N1200.ELearning.BL.BO.View.Unit _unit = null;

                foreach (PI.ZB.N1200.ELearning.BL.BO.View.Unit _loopUnit in Units)
                {
                    if (_loopUnit.ID == ID)
                    {
                        _unit = _loopUnit;
                        break;
                    }
                }

                return _unit;
            }

            public int? ExerciseDifficultyID
            {
                get
                {
                    if (Student != null)
                    {
                        if (CourseType == Dictionary.Category.CourseType.CompetenceCourse)
                        {
                            if (!_exerciseDifficultyID.HasValue)
                            {
                                BO.Student_CompetencePart _Student_CompetencePart = BLP.Statistic.Student.CompetencePart.Restore(this);
                                if (_Student_CompetencePart != null)
                                {
                                    BO.AdvancedLevel _CompetencePartAdvancedLevel = BLP.AdvancedLevel.Restore(_Student_CompetencePart.AdvancedLevelID_Start);

                                    if (_CompetencePartAdvancedLevel != null)
                                    {
                                        _exerciseDifficultyID = _CompetencePartAdvancedLevel.DifficultyEnumID;
                                    }
                                }

                                if ((!_exerciseDifficultyID.HasValue) && (AdvancedLevel != null))
                                {
                                    _exerciseDifficultyID = AdvancedLevel.DifficultyEnumID;
                                }                                
                            }
                        }
                    }

                    return _exerciseDifficultyID;
                }
            }

            public PI.ZB.N1200.ELearning.BL.BO.AdvancedLevel AdvancedLevel
            {
                get
                {
                    if (Student != null)
                    {
                        if ((CourseType == Dictionary.Category.CourseType.CompetenceCourse) || (CourseType == Dictionary.Category.CourseType.Case))
                        {
                            if (_AdvancedLevel == null)
                            {
                                _AdvancedLevel = BLP.AdvancedLevel.Restore(Student.CurrentAdvancedLevelID);
                            }
                        }
                    }

                    return _AdvancedLevel;
                }
            }

            public PI.ZB.N1200.ELearning.BL.BO.EvaluationSheet EvaluationSheet
            {
                get
                {
                    if (Student != null)
                    {
                        if (_currentEvaluationSheet == null)
                        {
                            if (Student.CurrentEvaluationSheetID.HasValue)
                            {
                                _currentEvaluationSheet = BLP.EvaluationSheet.Restore(Student.CurrentEvaluationSheetID);
                            }
                            else
                            {
                                List<PI.ZB.N1200.ELearning.BL.BO.EvaluationSheet> _listEvaluationSheet = BLP.EvaluationSheet.Restore();
                                _currentEvaluationSheet = _listEvaluationSheet[0];
                            }
                        }
                    }

                    return _currentEvaluationSheet;
                }
            }

            protected bool IsResolveable
            {
                get { return ExerciseOut.IsResolveable ?? false; }
            }

            protected bool IsNextExercise
            {
                get
                {
                    CalculatePageNumbers();

                    return _isNextExercise;
                }
            }

            protected bool IsPreviousExercise
            {
                get
                {
                    CalculatePageNumbers();

                    return _isPreviousExercise;
                }
            }

            protected bool IsMenu
            {
                get { return Units.Count > 1 ? true : false; }
            }

            public int PageNr
            {
                get
                {
                    CalculatePageNumbers();
                    return _pageNr;
                }
            }

            public int PageCount
            {
                get
                {
                    CalculatePageNumbers();

                    return _pageCount;
                }
            }

            public Dictionary.AuxyliaryPagesType AuxyliaryPages
            {
                get
                {
                    return _auxyliaryPage;
                }
                set
                {
                    _auxyliaryPage = value;
                }
            }

            public decimal RandomizePercent
            {
                get
                {
                    if (!_RandomizePercent.HasValue)
                    {
                        if (CourseType == Dictionary.Category.CourseType.KnowledgeTest)
                        {
                            if (BLP.RBL.VariableRepository.GetLong(BL.Dictionary.Config.Tests.StartKnowledgeTest.CourseID, BL.Dictionary.Clients.PlugIn) == Course.ID)
                            {
                                _RandomizePercent = BLP.RBL.VariableRepository.GetDecimal(BL.Dictionary.Config.Tests.StartKnowledgeTest.RandomizePercent, BL.Dictionary.Clients.PlugIn, 100);
                            }
                            else
                            {
                                _RandomizePercent = BLP.RBL.VariableRepository.GetDecimal(BL.Dictionary.Config.Tests.EndKnowledgeTest.RandomizePercent, BL.Dictionary.Clients.PlugIn, 100);
                            }
                        }
                        else if (CourseType == Dictionary.Category.CourseType.Case)
                        {
                            _RandomizePercent = CompetencePart.CaseRandomizePercent.HasValue ? CompetencePart.CaseRandomizePercent.Value : 100;
                        }
                        else if (CourseType == Dictionary.Category.CourseType.CompetenceCourse)
                        {
                            _RandomizePercent = CompetencePart.CompetenceCourseRandomizePercent.HasValue ? CompetencePart.CompetenceCourseRandomizePercent.Value : 100;
                        }
                        else
                        {
                            _RandomizePercent = 100;
                        }
                    }

                    return _RandomizePercent.Value;
                }
            }

            public bool IsCourseFinished
            {
                get
                {
                    if (!_isCourseFinished.HasValue)
                    {
                        _isCourseFinished = BLP.Course.IsFinised(this);
                    }

                    return _isCourseFinished.Value;
                }
            }

            public bool IsCompetencePartAvailable
            {
                get
                {
                    if (!_isCompetencePartAvailable.HasValue)
                    {
                        if ((CompetencePart != null) && (Class != null))
                        {
                            _isCompetencePartAvailable = BLP.CompetencePart.Class.IsAvailable(CompetencePart, Class);
                        }
                        else
                        {
                            _isCompetencePartAvailable = true;
                        }
                    }

                    return _isCompetencePartAvailable.Value;
                }
            }

            public bool IsExerciseAlreadyChecked
            {
                get
                {
                    if (!_isExerciseAlreadyChecked.HasValue)
                    {
                        if (Group == Dictionary.GroupType.Student)
                        {
                            _isExerciseAlreadyChecked = BLP.BLELearning.Statistic.Exercise.IsExerciseChecked(BLP.Environment.User, ContextObjectID, Course, UnitIn, ExerciseIn);
                        }
                        else
                        {
                            _isExerciseAlreadyChecked = false;
                        }
                    }

                    return _isExerciseAlreadyChecked.Value;
                }
            }

            public bool IsExerciseAlreadyResolved
            {
                get
                {
                    if (!_isExerciseAlreadyResolved.HasValue)
                    {
                        if (Group == Dictionary.GroupType.Student)
                        {
                            _isExerciseAlreadyResolved = BLP.BLELearning.Statistic.Exercise.IsExerciseResolved(BLP.Environment.User, ContextObjectID, Course, UnitIn, ExerciseIn);
                        }
                        else
                        {
                            _isExerciseAlreadyResolved = false;
                        }
                    }

                    return _isExerciseAlreadyResolved.Value;
                }
            }         

            private void CalculatePageNumbers()
            {
                if (!_isPageCalculated)
                {
                    if ((Group == Dictionary.GroupType.Student) && (CourseType != Dictionary.Category.CourseType.CompetenceTheory))
                    {
                        if (IsCourseFinished && (Mode == GM.N610.ELearning.BL.Dictionary.ModeType.History))
                        {
                            _pageCount = BLP.BLELearning.Statistic.History.Count(BLP.Environment.User, ContextObjectID, Course);

                            if (_pageCount > 0)
                            {
                                if ((UnitOut != null) && (ExerciseOut != null))
                                {
                                    _pageNr = BLP.BLELearning.Statistic.History.CountPosition(BLP.Environment.User, ContextObjectID, Course, UnitOut, ExerciseOut);
                                }
                            }
                            else
                            {
                                _isPreviousExercise = false;
                                _isNextExercise = false;
                            }
                        }
                        else
                        {
                            _pageCount = BLP.Course.CountExerciseTotal(this);
                            _pageNr = BLP.Course.CountExerciseDone(this) + (ExerciseState == GM.N610.ELearning.BL.ELearning.ExerciseState.Load ? 1 : 0);

                            _isPreviousExercise = false;
                            _isNextExercise = true;
                        }
                    }
                    else
                    {
                        _pageCount = Unit(UnitOut.ID).ExerciseTotal ?? 0;

                        if ((UnitOut != null) && (ExerciseOut != null))
                        {
                            _pageNr = BLP.BLELearning.Exercise.CountActivePositionInUnit(UnitOut, ExerciseOut);
                        }

                        _isPreviousExercise = _pageNr > 1;
                        _isNextExercise = _pageNr < _pageCount;
                    }
                    _isPageCalculated = true;
                    _menu = null;
                }
            }

            public void Refresh()
            {
                _isPageCalculated = false;
                _menu = null;
                if (_listUnit != null)
                {
                    _listUnit.Clear();
                    _listUnit = null;
                }
            }

            public bool IsValidContext
            {
                get
                {
                    if (!_isValidContext.HasValue)
                    {
                        if (ValidContext != null)
                        {
                            if ((ContextObjectID == ValidContext.ContextObjectID) && (Course.ID == ValidContext.Course.ID))
                            {
                                _isValidContext = true;
                            }
                            else
                            {
                                _isValidContext = false;
                            }
                        }
                        else
                        {
                            _isValidContext = false;
                        }
                    }

                    return _isValidContext.Value;
                }
            }

            public ContextParam ValidContext
            {
                get 
                {
                    if ((!_isValidContextCalculated) && (Group == Dictionary.GroupType.Student))
                    {
                        _validContext = BLP.Utility.GetValidContext(Student);
                        _isValidContextCalculated = true;
                    }

                    return _validContext;
                }
            }
        }
    }
}
